//---------------------------------------------------------------------------
#ifndef BlowfishH
#define BlowfishH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------

#define	ERROR_FREE			                        0
#define KEY_TOO_LONG		                        1
#define NOT_ENOUGH_MEMORY	                        2
#define BAD_SOURCE			                        3
#define BAD_SIZE			                        4
#define NOT_LOCK_SOURCE		                        5
#define DO_NOT_SUPPORT_FOR_UNREGISTERED_VERSION     6
#define NOT_SUPPORT_PREVIOUS_VERSION				7
#define BAD_CRC                                     8

//---------------------------------------------------------------------------
class PACKAGE TBlowfish : public TComponent
{
private:
    AnsiString	BlowfishKey;
    UINT		LastErrorCode;

    bool	CrcChecker;
    bool    Display_E_Nag;
    bool	Display_D_Nag;

    unsigned long proc_P[18];
	unsigned long proc_sbox0[256], proc_sbox1[256], proc_sbox2[256], proc_sbox3[256];

    void IniitializeBlowfish(char *key, short keybytes);
    void Blowfish_encipher(unsigned long *xl, unsigned long *xr);
    void Blowfish_decipher(unsigned long *xl, unsigned long *xr);
    void ResetBox(void);
    unsigned long F(unsigned long x);
    void crcupdate(unsigned char *data, unsigned short *accum);
    long CRC(unsigned char *DataPtr, unsigned long Size);

protected:

public:
    UINT GetErrorCode(void);
	BYTE* Auto_Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Auto_Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    bool InitializeKey(void);
    BYTE* Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);

    __fastcall TBlowfish(TComponent* Owner);

__published:
	__property AnsiString Key = {read=BlowfishKey, write=BlowfishKey};
    __property bool       Crc_Check = {read=CrcChecker, write=CrcChecker};

};
//---------------------------------------------------------------------------
#endif
 